/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __InicronRAMROM_HEADER_INCLUDED__
#define __InicronRAMROM_HEADER_INCLUDED__

#include "cpc.h"

/* Inicron RAM-ROM */

#define RAM_ROM_FLAGS_RAM_ON	0x0001
#define RAM_ROM_FLAGS_RAM_WRITE_ENABLE	0x0002
#define RAM_ROM_FLAGS_EPROM_ON	0x0004

void	InicronRAMROM_Initialise(int NumBlocks);
void	InicronRAMROM_Finish(void);
void	InicronRAMROM_SetBankEnable(int Bank, BOOL State);
BOOL	InicronRAMROM_GetBankEnableState(int Bank);
void	InicronRAMROM_RethinkMemory(MemoryData *pData);
BOOL	InicronRAMROM_IsRamOn(void);
BOOL	InicronRAMROM_IsRamWriteEnabled(void);
void	InicronRAMROM_SetRamOnState(BOOL);
void	InicronRAMROM_SetRamWriteEnableState(BOOL);
void	InicronRAMROM_SetEPROMOnState(BOOL);
BOOL	InicronRAMROM_IsEPROMOn(void);
void	InicronRAMROM_SetupTable(void);
void RamRom_Finish(void);
void RamRom_Init(void);

#endif
